// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/application/public/interfaces/application.mojom
//

package org.chromium.mojom.mojo;

class Application_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<Application, Application.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<Application, Application.Proxy>() {
    
        public String getName() {
            return "mojo::Application";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, Application impl) {
            return new Stub(core, impl);
        }
    
        public Application[] buildArray(int size) {
          return new Application[size];
        }
    };

    private static final int INITIALIZE_ORDINAL = 0;
    private static final int ACCEPT_CONNECTION_ORDINAL = 1;
    private static final int ON_QUIT_REQUESTED_ORDINAL = 2;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements Application.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void initialize(Shell shell, String url) {
            ApplicationInitializeParams _message = new ApplicationInitializeParams();
            _message.shell = shell;
            _message.url = url;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(INITIALIZE_ORDINAL)));
        }

        @Override
        public void acceptConnection(String requestorUrl, org.chromium.mojo.bindings.InterfaceRequest<ServiceProvider> services, ServiceProvider exposedServices, String[] allowedInterfaces, String resolvedUrl) {
            ApplicationAcceptConnectionParams _message = new ApplicationAcceptConnectionParams();
            _message.requestorUrl = requestorUrl;
            _message.services = services;
            _message.exposedServices = exposedServices;
            _message.allowedInterfaces = allowedInterfaces;
            _message.resolvedUrl = resolvedUrl;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(ACCEPT_CONNECTION_ORDINAL)));
        }

        @Override
        public void onQuitRequested(OnQuitRequestedResponse callback) {
            ApplicationOnQuitRequestedParams _message = new ApplicationOnQuitRequestedParams();
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ON_QUIT_REQUESTED_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ApplicationOnQuitRequestedResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<Application> {

        Stub(org.chromium.mojo.system.Core core, Application impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                Application_Internal.MANAGER, messageWithHeader);
                    case INITIALIZE_ORDINAL: {
                        ApplicationInitializeParams data =
                                ApplicationInitializeParams.deserialize(messageWithHeader.getPayload());
                        getImpl().initialize(data.shell, data.url);
                        return true;
                    }
                    case ACCEPT_CONNECTION_ORDINAL: {
                        ApplicationAcceptConnectionParams data =
                                ApplicationAcceptConnectionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().acceptConnection(data.requestorUrl, data.services, data.exposedServices, data.allowedInterfaces, data.resolvedUrl);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), Application_Internal.MANAGER, messageWithHeader, receiver);
                    case ON_QUIT_REQUESTED_ORDINAL: {
                        ApplicationOnQuitRequestedParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onQuitRequested(new ApplicationOnQuitRequestedResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ApplicationInitializeParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public Shell shell;
        public String url;
    
        private ApplicationInitializeParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ApplicationInitializeParams() {
            this(0);
        }
    
        public static ApplicationInitializeParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ApplicationInitializeParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationInitializeParams result = new ApplicationInitializeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.shell = decoder0.readServiceInterface(8, false, Shell.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(shell, 8, false, Shell.MANAGER);
            encoder0.encode(url, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ApplicationInitializeParams other = (ApplicationInitializeParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.shell, other.shell))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(shell);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
            return result;
        }
    }

    static final class ApplicationAcceptConnectionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 48;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String requestorUrl;
        public org.chromium.mojo.bindings.InterfaceRequest<ServiceProvider> services;
        public ServiceProvider exposedServices;
        public String[] allowedInterfaces;
        public String resolvedUrl;
    
        private ApplicationAcceptConnectionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ApplicationAcceptConnectionParams() {
            this(0);
        }
    
        public static ApplicationAcceptConnectionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ApplicationAcceptConnectionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationAcceptConnectionParams result = new ApplicationAcceptConnectionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestorUrl = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.services = decoder0.readInterfaceRequest(16, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.exposedServices = decoder0.readServiceInterface(20, true, ServiceProvider.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.allowedInterfaces = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        result.allowedInterfaces[i1] = decoder1.readString(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.resolvedUrl = decoder0.readString(40, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(requestorUrl, 8, false);
            encoder0.encode(services, 16, true);
            encoder0.encode(exposedServices, 20, true, ServiceProvider.MANAGER);
            if (allowedInterfaces == null) {
                encoder0.encodeNullPointer(32, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(allowedInterfaces.length, 32, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < allowedInterfaces.length; ++i0) {
                    encoder1.encode(allowedInterfaces[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            encoder0.encode(resolvedUrl, 40, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ApplicationAcceptConnectionParams other = (ApplicationAcceptConnectionParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.requestorUrl, other.requestorUrl))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.services, other.services))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.exposedServices, other.exposedServices))
                return false;
            if (!java.util.Arrays.deepEquals(this.allowedInterfaces, other.allowedInterfaces))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.resolvedUrl, other.resolvedUrl))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(requestorUrl);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(services);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(exposedServices);
            result = prime * result + java.util.Arrays.deepHashCode(allowedInterfaces);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(resolvedUrl);
            return result;
        }
    }

    static final class ApplicationOnQuitRequestedParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private ApplicationOnQuitRequestedParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ApplicationOnQuitRequestedParams() {
            this(0);
        }
    
        public static ApplicationOnQuitRequestedParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ApplicationOnQuitRequestedParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationOnQuitRequestedParams result = new ApplicationOnQuitRequestedParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class ApplicationOnQuitRequestedResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean canQuit;
    
        private ApplicationOnQuitRequestedResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ApplicationOnQuitRequestedResponseParams() {
            this(0);
        }
    
        public static ApplicationOnQuitRequestedResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ApplicationOnQuitRequestedResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationOnQuitRequestedResponseParams result = new ApplicationOnQuitRequestedResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.canQuit = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(canQuit, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ApplicationOnQuitRequestedResponseParams other = (ApplicationOnQuitRequestedResponseParams) object;
            if (this.canQuit != other.canQuit)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(canQuit);
            return result;
        }
    }

    static class ApplicationOnQuitRequestedResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final Application.OnQuitRequestedResponse mCallback;

        ApplicationOnQuitRequestedResponseParamsForwardToCallback(Application.OnQuitRequestedResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_QUIT_REQUESTED_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                ApplicationOnQuitRequestedResponseParams response = ApplicationOnQuitRequestedResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.canQuit);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ApplicationOnQuitRequestedResponseParamsProxyToResponder implements Application.OnQuitRequestedResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ApplicationOnQuitRequestedResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean canQuit) {
            ApplicationOnQuitRequestedResponseParams _response = new ApplicationOnQuitRequestedResponseParams();
            _response.canQuit = canQuit;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    ON_QUIT_REQUESTED_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

